using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameOverScript : MonoBehaviour
{

    [SerializeField] string[] tags;

    void Start()
    {

        foreach (string tag in tags)
        {
            GameObject[] go = GameObject.FindGameObjectsWithTag(tag);

            foreach (GameObject g in go)
            {
                g.SetActive(false);
            }
        }

        GameObject.Find("Music Background").GetComponent<AudioSource>().enabled = false;
        StartCoroutine(LoadMenu());
    }

    IEnumerator LoadMenu()
    {
        yield return new WaitForSeconds(6f);
        UnityEngine.SceneManagement.SceneManager.LoadScene("Menu");
    }

private void Awake()
    {
        if (PlayerPrefs.GetInt("mute")==0)
        {
            GetComponent<AudioSource>().enabled = false;
        }

    }

    public void Replay()
    {
        SceneManager.LoadScene(1);
        Time.timeScale = 1;
    }

    public void LoadeMenu()
    {
        SceneManager.LoadScene("Menu");
    }
}